﻿Module Module1

    Sub Main()
        Dim ID, ErrMsg As String
        Dim alpha(26) As String
        Dim N, N0, N1, Sum As Integer
        ErrMsg = ""
        '建立字母對照表
        alpha(1) = "10" : alpha(14) = "22"
        alpha(2) = "11" : alpha(15) = "35"
        alpha(3) = "12" : alpha(16) = "23"
        alpha(4) = "13" : alpha(17) = "24"
        alpha(5) = "14" : alpha(18) = "25"
        alpha(6) = "15" : alpha(19) = "26"
        alpha(7) = "16" : alpha(20) = "27"
        alpha(8) = "17" : alpha(21) = "28"
        alpha(9) = "34" : alpha(22) = "29"
        alpha(10) = "18" : alpha(23) = "32"
        alpha(11) = "19" : alpha(24) = "30"
        alpha(12) = "20" : alpha(25) = "31"
        alpha(13) = "21" : alpha(26) = "33"

        Console.Write("請輸入身份證字號: ")
        ID = Console.ReadLine().ToUpper
        If Len(ID) <> 10 Then  '檢查長度是否為10個字
            ErrMsg = "身分證字號長度錯誤"
        Else   '檢查第一碼是否為英文字
            If Mid(ID, 1, 1) < "A" Or Mid(ID, 1, 1) > "Z" Then
                ErrMsg = ErrMsg & vbCrLf & "身分證字號格式錯誤,第一碼應為英文"
            End If
            If Mid(ID, 2, 1) <> "1" And Mid(ID, 2, 1) <> "2" Then '檢查性別
                ErrMsg = ErrMsg & vbCrLf & "性別錯誤,第二碼應為1或2"
            End If
            For i = 2 To 10   '檢查後九碼是否為數字
                If Mid(ID, i, 1) < "0" Or Mid(ID, i, 1) > "9" Then
                    ErrMsg = ErrMsg & vbCrLf & "身分證字號後九碼應為數字"
                    Exit For
                End If
            Next
            If ErrMsg = "" Then  '計算檢查碼是否正確
                N0 = Val(Mid(alpha(Asc(Mid(ID, 1, 1)) - 64), 1, 1))
                N1 = Val(Mid(alpha(Asc(Mid(ID, 1, 1)) - 64), 2, 1)) * 9
                N = 0
                For i = 2 To 9
                    N = N + Mid(ID, i, 1) * (10 - i)
                Next
                Sum = (N0 + N1 + N) Mod 10
                If Sum <> 0 Then Sum = 10 - Sum
                If Sum <> Val(Mid(ID, 10, 1)) Then
                    ErrMsg = ErrMsg & Chr(13) & "身分證字號檢查碼不符"
                End If
            End If
        End If
        '印出訊息
        If ErrMsg = "" Then
            Console.WriteLine("這是正確的身分證字號")
        Else
            Console.WriteLine(ErrMsg)
        End If
        Console.Read()
    End Sub

End Module
